<?php

require 'vendor/autoload.php';
require 'db.php';

use Longman\TelegramBot\Request;
use Longman\TelegramBot\Telegram;

define('DEBUG_MODE', true);

function logDebug($message)
{
    if (DEBUG_MODE) {
        file_put_contents('debug_log.txt', date('[Y-m-d H:i:s] ') . $message . PHP_EOL, FILE_APPEND);
    }
}

// Initialize Telegram
$bot_api_key = '7598347909:AAF6Hh8SzuP0X_ZmDsdG4R4aVcs7abUIKAg';
$bot_username = 'Mloans_Bot';
$telegram = new Telegram($bot_api_key, $bot_username);

// Initialize database
$database = new Database();

try {
    // Get the callback data
    $callbackData = file_get_contents('php://input');
    logDebug("M-Pesa Callback received: " . $callbackData);

    $callback = json_decode($callbackData, true);

    if ($callback) {
        // Extract relevant information
        $resultCode = $callback['Body']['stkCallback']['ResultCode'];
        $merchantRequestID = $callback['Body']['stkCallback']['MerchantRequestID'];
        $checkoutRequestID = $callback['Body']['stkCallback']['CheckoutRequestID'];

        if ($resultCode == 0) {
            // Payment successful
            $mpesaReceipt = $callback['Body']['stkCallback']['CallbackMetadata']['Item'][1]['Value'];
            $amount = $callback['Body']['stkCallback']['CallbackMetadata']['Item'][0]['Value'];
            $phoneNumber = $callback['Body']['stkCallback']['CallbackMetadata']['Item'][4]['Value'];

            try {
                // Get user by phone number
                $user = $database->getUserByPhone($phoneNumber);
                if ($user) {
                    // Get loan transaction details
                    $loanTransaction = $database->getLoanTransaction($merchantRequestID);

                    if ($loanTransaction) {
                        // Get state file to retrieve loan amount
                        $stateFile = "loan_state_{$user['chat_id']}.json";
                        $state = [];
                        if (file_exists($stateFile)) {
                            $state = json_decode(file_get_contents($stateFile), true);
                        }

                        $loanAmount = $state['loan_amount'] ?? $amount;

                        try {
                            // First create the loan
                            $loan_id = $database->createLoan(
                                $user['id'],
                                $loanAmount,
                                date('Y-m-d', strtotime('+4 months')),
                                $mpesaReceipt
                            );
                            logDebug("Created loan with ID: $loan_id");

                            // Then update the loan transaction with both loan_id and completed status
                            $database->updateLoanTransactionLoanId($merchantRequestID, $loan_id);
                            logDebug("Updated loan transaction with loan_id: $loan_id and status: completed");
                        } catch (Exception $e) {
                            logDebug("Error in loan processing: " . $e->getMessage());
                            throw $e;
                        }

                        // Send success message to user
                        $message = "✅ Payment Successful!\n\n" .
                            "Your loan application has been submitted successfully.\n" .
                            "Transaction ID: " . $mpesaReceipt . "\n" .
                            "Amount Paid: KES " . number_format($amount) . "\n" .
                            "Loan Amount: KES " . number_format($loanAmount) . "\n\n" .
                            "You will receive your loan after verification within 24 hours.\n\n" .
                            "Need help? Use these options:\n" .
                            "1. 📜 View Terms & Conditions\n" .
                            "2. 📞 Contact Support\n" .
                            "3. 👥 Refer Friends";

                        $keyboard = [
                            'inline_keyboard' => [
                                [
                                    ['text' => '📜 Terms & Conditions', 'callback_data' => 'view_terms'],
                                    ['text' => '📞 Contact Us', 'callback_data' => 'contact_us']
                                ],
                                [
                                    ['text' => '👥 Refer Friends', 'callback_data' => 'refer_friends']
                                ]
                            ]
                        ];

                        Request::sendMessage([
                            'chat_id' => $user['chat_id'],
                            'text' => $message,
                            'reply_markup' => json_encode($keyboard)
                        ]);
                    } else {
                        logDebug("No loan transaction found for merchant request ID: " . $merchantRequestID);
                    }
                } else {
                    logDebug("No user found for phone number: " . $phoneNumber);
                }
            } catch (Exception $e) {
                logDebug("Error processing successful payment: " . $e->getMessage());
            }
        } else {
            // Payment failed
            try {
                $database->updateLoanTransaction($merchantRequestID, 'failed');
                logDebug("Updated loan transaction status to failed");

                // Find user and send failure message
                $phoneNumber = $callback['Body']['stkCallback']['CallbackMetadata']['Item'][4]['Value'] ?? null;
                if ($phoneNumber) {
                    $user = $database->getUserByPhone($phoneNumber);
                    if ($user) {
                        $message = "❌ Payment Failed\n\n" .
                            "Your payment was not completed.\n" .
                            "Please try again or contact support if the problem persists.";

                        Request::sendMessage([
                            'chat_id' => $user['chat_id'],
                            'text' => $message
                        ]);
                    }
                }
            } catch (Exception $e) {
                logDebug("Error processing failed payment: " . $e->getMessage());
            }
        }
    }

    // Return success response to M-Pesa
    header("Content-Type: application/json");
    echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Success']);
} catch (Exception $e) {
    logDebug("Callback Error: " . $e->getMessage());
    header("Content-Type: application/json");
    echo json_encode(['ResultCode' => 1, 'ResultDesc' => 'Error processing callback']);
}
